library pack1076;
use pack1076.pack1076.all;


entity LPMMULT8 is port (
   signal DataA:  in  vlbit_vector (3 downto 0);
   signal DataB:  in  vlbit_vector (3 downto 0);
   signal Result: out vlbit_vector (7 downto 0));
end LPMMULT8;

architecture lpm of LPMMULT8 is begin
   process (DataA, DataB)
      variable a0:  vlbit_vector (3 downto 0);
      variable xi0: vlbit_vector (3 downto 0);
      variable xo0: vlbit_vector (4 downto 0);
      variable a1:  vlbit_vector (3 downto 0);
      variable xi1: vlbit_vector (3 downto 0);
      variable xo1: vlbit_vector (4 downto 0);
      variable a2:  vlbit_vector (3 downto 0);
      variable xi2: vlbit_vector (3 downto 0);
      variable xo2: vlbit_vector (4 downto 0);
      variable a3:  vlbit_vector (3 downto 0);
      variable xi3: vlbit_vector (3 downto 0);
      variable xo3: vlbit_vector (4 downto 0);
      variable xb0: vlbit_vector (3 downto 0);
      variable xb1: vlbit_vector (3 downto 0);
      variable xb2: vlbit_vector (3 downto 0);
      variable xb3: vlbit_vector (3 downto 0);
   begin

      -- Create matrix of A anded with B
      a0 :=
         (DataA (3) and DataB (0)) &
         (DataA (2) and DataB (0)) &
         (DataA (1) and DataB (0)) &
         (DataA (0) and DataB (0));
      a1 :=
         (DataA (3) and DataB (1)) &
         (DataA (2) and DataB (1)) &
         (DataA (1) and DataB (1)) &
         (DataA (0) and DataB (1));
      a2 :=
         (DataA (3) and DataB (2)) &
         (DataA (2) and DataB (2)) &
         (DataA (1) and DataB (2)) &
         (DataA (0) and DataB (2));
      a3 :=
         (DataA (3) and DataB (3)) &
         (DataA (2) and DataB (3)) &
         (DataA (1) and DataB (3)) &
         (DataA (0) and DataB (3));

      -- Fill initial row of xb
      xb0 (0) := a0 (0+1);
      xb1 (0) := a0 (1+1);
      xb2 (0) := a0 (2+1);
      xb3 (0) := '0';
      
      -- Perform addition of bit 1
      xi1 (0) := xb0 (1-1);
      xi1 (1) := xb1 (1-1);
      xi1 (2) := xb2 (1-1);
      xi1 (3) := xb3 (1-1);
      xo1 := addum (xi1, a1);
      xb0 (1) := xo1 (0+1);
      xb1 (1) := xo1 (1+1);
      xb2 (1) := xo1 (2+1);
      xb3 (1) := xo1 (3+1);

      -- Perform addition of bit 2
      xi2 (0) := xb0 (2-1);
      xi2 (1) := xb1 (2-1);
      xi2 (2) := xb2 (2-1);
      xi2 (3) := xb3 (2-1);
      xo2 := addum (xi2, a2);
      xb0 (2) := xo2 (0+1);
      xb1 (2) := xo2 (1+1);
      xb2 (2) := xo2 (2+1);
      xb3 (2) := xo2 (3+1);

      -- Perform addition of bit 3
      xi3 (0) := xb0 (3-1);
      xi3 (1) := xb1 (3-1);
      xi3 (2) := xb2 (3-1);
      xi3 (3) := xb3 (3-1);
      xo3 := addum (xi3, a3);
      xb0 (3) := xo3 (0+1);
      xb1 (3) := xo3 (1+1);
      xb2 (3) := xo3 (2+1);
      xb3 (3) := xo3 (3+1);

      -- Assign to result
      Result <= 
         (xo3 (4)) &
         (xo3 (3)) &
         (xo3 (2)) &
         (xo3 (1)) &
         (xo3 (0)) &
         (xo2 (0)) &
         (xo1 (0)) &
         (a0 (0))
         after 0 ns;
   end process;
end lpm;
